/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util.culling;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import meldexun.entityculling.EntityCulling;
import meldexun.entityculling.util.ICullable;
import meldexun.entityculling.util.ResourceSupplier;
import meldexun.entityculling.util.culling.GLHelper;
import meldexun.matrixutil.Matrix4f;
import meldexun.renderlib.util.BufferUtil;
import meldexun.renderlib.util.GLBuffer;
import meldexun.renderlib.util.GLShader;
import meldexun.renderlib.util.GLUtil;
import meldexun.renderlib.util.RenderUtil;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL42;

public class CullingInstance {
    private static final int MAX_OBJ_COUNT = 65536;
    private static final String A_POS = "a_Pos";
    private static final String A_OFFSET = "a_Offset";
    private static final String A_SIZE = "a_Size";
    private static final String A_OBJID = "a_ObjID";
    private static final String U_MATRIX = "u_ModelViewProjectionMatrix";
    private static CullingInstance instance;
    private static CullingInstance shadow_instance;
    private final GLShader shader = new GLShader.Builder().addShader(35633, (Supplier)new ResourceSupplier(new ResourceLocation("entityculling", "shaders/vert.glsl"))).addShader(35632, (Supplier)new ResourceSupplier(new ResourceLocation("entityculling", "shaders/frag.glsl"))).build();
    public final int cubeVertexBuffer;
    public final int cubeIndexBuffer;
    private final GLBuffer vboBuffer = new GLBuffer(0x1C0000L, 2, 0, true, 2);
    private final int vao;
    private final GLBuffer cpuSSBO = new GLBuffer(262144L, 513, 0, true, 1);
    private final GLBuffer gpuSSBO = new GLBuffer(262144L, 0, 0);
    private int syncQuery = -1;
    private int objCount;
    private int frame;

    public CullingInstance() {
        this.cubeVertexBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.cubeVertexBuffer);
        GL15.glBufferData((int)34962, (ByteBuffer)BufferUtil.buffer((byte[])new byte[]{0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1}), (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        this.cubeIndexBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)this.cubeIndexBuffer);
        GL15.glBufferData((int)34963, (ByteBuffer)BufferUtil.buffer((byte[])new byte[]{7, 3, 5, 1, 0, 3, 2, 7, 6, 5, 4, 0, 6, 2}), (int)35044);
        GL15.glBindBuffer((int)34963, (int)0);
        this.vao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.vao);
        GL15.glBindBuffer((int)34962, (int)this.cubeVertexBuffer);
        GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_POS), (int)3, (int)5120, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_POS));
        GL15.glBindBuffer((int)34962, (int)this.vboBuffer.getBuffer());
        GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_OFFSET), (int)3, (int)5126, (boolean)false, (int)28, (long)0L);
        GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_SIZE), (int)3, (int)5126, (boolean)false, (int)28, (long)12L);
        GL30.glVertexAttribIPointer((int)this.shader.getAttribute(A_OBJID), (int)1, (int)5124, (int)28, (long)24L);
        GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_OFFSET));
        GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_SIZE));
        GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_OBJID));
        GL33.glVertexAttribDivisor((int)this.shader.getAttribute(A_OFFSET), (int)1);
        GL33.glVertexAttribDivisor((int)this.shader.getAttribute(A_SIZE), (int)1);
        GL33.glVertexAttribDivisor((int)this.shader.getAttribute(A_OBJID), (int)1);
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)this.cubeIndexBuffer);
        GL30.glBindVertexArray((int)0);
    }

    public static CullingInstance getInstance() {
        if (instance == null) {
            instance = new CullingInstance();
        }
        return instance;
    }

    public static CullingInstance getShadowInstance() {
        if (shadow_instance == null) {
            shadow_instance = new CullingInstance();
        }
        return shadow_instance;
    }

    public boolean isVisible(ICullable.CullInfo cullInfo) {
        if (!cullInfo.wasLastTimeUpdated(this.frame)) {
            return true;
        }
        if (this.syncQuery != -1) {
            GL33.glGetQueryObjecti64((int)this.syncQuery, (int)34918);
            GL15.glDeleteQueries((int)this.syncQuery);
            this.syncQuery = -1;
        }
        return this.cpuSSBO.getBoolean((long)(cullInfo.getId(this.frame) * 4));
    }

    public void addBox(ICullable.CullInfo cullInfo, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (cullInfo.getLastTimeUpdated() == this.frame) {
            return;
        }
        if (RenderUtil.getCameraX() >= minX && RenderUtil.getCameraX() <= maxX && RenderUtil.getCameraY() >= minY && RenderUtil.getCameraY() <= maxY && RenderUtil.getCameraZ() >= minZ && RenderUtil.getCameraZ() <= maxZ) {
            return;
        }
        this.vboBuffer.putFloat((long)(this.objCount * 28), (float)(minX - RenderUtil.getCameraEntityX()));
        this.vboBuffer.putFloat((long)(this.objCount * 28 + 4), (float)(minY - RenderUtil.getCameraEntityY()));
        this.vboBuffer.putFloat((long)(this.objCount * 28 + 8), (float)(minZ - RenderUtil.getCameraEntityZ()));
        this.vboBuffer.putFloat((long)(this.objCount * 28 + 12), (float)(maxX - minX));
        this.vboBuffer.putFloat((long)(this.objCount * 28 + 16), (float)(maxY - minY));
        this.vboBuffer.putFloat((long)(this.objCount * 28 + 20), (float)(maxZ - minZ));
        this.vboBuffer.putInt((long)(this.objCount * 28 + 24), this.objCount);
        cullInfo.setLastTimeUpdated(this.frame);
        cullInfo.setId(this.objCount);
        ++this.objCount;
    }

    public void updateResults(Matrix4f projViewMat) {
        ++this.frame;
        if (this.objCount > 0) {
            EntityCulling.gpuTimer.start();
            GLHelper.clearBufferSubData(this.gpuSSBO.getBuffer(), 0L, this.objCount * 4, 0);
            GLShader.push();
            this.shader.use();
            GLUtil.setMatrix((int)this.shader.getUniform(U_MATRIX), (Matrix4f)projViewMat);
            GL30.glBindBufferBase((int)37074, (int)1, (int)this.gpuSSBO.getBuffer());
            this.setupRenderState();
            GL30.glBindVertexArray((int)this.vao);
            GL31.glDrawElementsInstanced((int)5, (int)14, (int)5121, (long)0L, (int)this.objCount);
            GL30.glBindVertexArray((int)0);
            this.clearRenderState();
            GL30.glBindBufferBase((int)37074, (int)1, (int)0);
            GLShader.pop();
            GLHelper.copyBufferSubData(this.gpuSSBO.getBuffer(), this.cpuSSBO.getBuffer(), 0L, 0L, this.objCount * 4);
            GL42.glMemoryBarrier((int)16384);
            if (this.syncQuery != -1) {
                GL15.glDeleteQueries((int)this.syncQuery);
                this.syncQuery = -1;
            }
            this.syncQuery = GL15.glGenQueries();
            GL33.glQueryCounter((int)this.syncQuery, (int)36392);
            this.objCount = 0;
            EntityCulling.gpuTimer.stop();
        }
    }

    private void setupRenderState() {
        GLHelper.saveShaderGLState();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179089_o();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
    }

    private void clearRenderState() {
        GLHelper.restoreShaderGLState();
    }
}

